<?php
session_start();
require 'config.php';

if ($_SERVER['REQUEST_METHOD'] != 'POST') {
	header($_SERVER['SERVER_PROTOCOL'] . ' 405 Method Not Allowed');
	die();
}
if ($_SESSION['status'] != 'teacher') {
	header($_SERVER['SERVER_PROTOCOL'] . ' 403 Forbidden');
	die();
}
if (!isset($_POST['password'])) {
	header($_SERVER['SERVER_PROTOCOL'] . ' 400 Bad Request');
	die();
}
if ($_POST['password'] != $teacher_password) {
	header($_SERVER['SERVER_PROTOCOL'] . ' 403 Forbidden');
	header('Location: index.php?error=Mauvais mot de passe.');
	die();
}

try {
	$pdo = new PDO($db_dsn, $db_user, $db_password);
} catch (PDOException $e) {
	print($e->getMessage());
	die();
}


function array_remove_item(int $item, array $arr): array { //helper function
	unset($arr[array_search($item, $arr)]);
	return array_values($arr);
}


function getTutor(array $tutors, $idStudents): int {
	$highestSlots = 0;
	foreach ($tutors as $tutor) { //there should at least a tutor with an available slot
		if ($tutor['slots'] > $highestSlots) $highestSlots = $tutor['slots'];
	}
	$tutorsIds = [];
	while (count($tutorsIds) == 0 && $highestSlots != 0) {
		foreach ($tutors as $idTutor => $tutor) { //select tutors by descending priority who can be satisfied
			if ($tutor['slots'] == $highestSlots && count(array_intersect($tutor['votes'], $idStudents)) != 0) $tutorsIds[] = $idTutor;
		}
		$highestSlots--;
	}
	if (count($tutorsIds) == 0) { //no tutor can be satisfied -> retrieve ones with at least an available slot
		foreach ($tutors as $idTutor => $tutor) {
			if ($tutor['slots'] != 0) $tutorsIds[] = $idTutor;
		}
	}
	return $tutorsIds[array_rand($tutorsIds)];
}


function getSelectedStudent(array $votes, array $studentsIds): int {
	$idStudent = 0;
	$i = 0;
	while ($i < count($votes) && $idStudent == 0) {
		if (in_array ($votes[$i], $studentsIds)) $idStudent = $votes[$i];
		$i++;
	}
	return $idStudent;
}

function getAvailableStudent(array $participations, array $studentsIds): int {
	$idStudent = 0;
	$i = 0;
	while ($i < count($studentsIds) && $idStudent == 0) {
		if (!in_array ($studentsIds[$i], $participations)) $idStudent = $studentsIds[$i];
		$i++;
	}
	return $idStudent;
}


function affectStudent(array $studentsIds, array &$tutors, int $idSession) : int {
	global $pdo; global $DEBUG;
	$idTutor = getTutor($tutors, $studentsIds);
	$idStudent = getSelectedStudent($tutors[$idTutor]['votes'], $studentsIds);
	if ($idStudent == 0) {
		$idStudent = getAvailableStudent($tutors[$idTutor]['participations'], $studentsIds);
		if ($DEBUG) echo "tutor: $idTutor -> student: $idStudent<br/>";
	} else {
		if ($DEBUG) echo "tutor: $idTutor -> student: $idStudent (selected)<br/>";
		$tutors[$idTutor]['votes'] = array_remove_item($idStudent, $tutors[$idTutor]['votes']);
	}
	if ($idStudent != 0) {
		$tutors[$idTutor]['slots']--;
		$tutors[$idTutor]['participations'][] = $idStudent;
		$pdo->query("INSERT INTO Participation (idTutor, idStudent, idSession) VALUES ($idTutor, $idStudent, $idSession)");
	}
	return $idStudent;
}


function fixAttributions(array &$tutors, array $availableStudentsIds, int $idSession): array {
	global $pdo; global $DEBUG;
	$studentsIds = [];
	foreach ($availableStudentsIds as $idStudent) {
		$availableTutorsIds = []; foreach ($tutors as $idTutor => $tutor) { if ($tutor['slots'] != 0) $availableTutorsIds[] = $idTutor; }
		$switch = false;
		$i = 0; while (!$switch && $i < count($availableTutorsIds)) {
			$idTutor = $availableTutorsIds[$i]; $i++;
			//~ $sql = "SELECT idTutor, idStudent FROM Participation WHERE idSession = $idSession " . //session participations
					//~ "AND idTutor NOT IN (SELECT idTutor FROM Participation WHERE idStudent = $idStudent) " . //whose tutors do not already have an interview with the available student
					//~ "AND idStudent NOT IN (SELECT idStudent FROM Participation WHERE idTutor = $idTutor"; //and whoses students do not already have an interview with the available tutor
			$sql = "SELECT p.idTutor, p.idStudent FROM Participation p " . //version optimisée
					"LEFT JOIN Participation p1 ON p.idTutor = p1.idTutor AND p1.idStudent = $idStudent " .
					"LEFT JOIN Participation p2 ON p.idStudent = p2.idStudent AND p2.idTutor = $idTutor " .
					"WHERE p.idSession = 2 AND p1.idTutor IS NULL AND p2.idStudent IS NULL";
			$r = $pdo->query($sql)->fetch(PDO::FETCH_OBJ);
			if ($r) {
				if ($DEBUG) echo "tutor $r->idTutor gives student $r->idStudent to tutor $idTutor and takes student $idStudent<br/> ";
				$tutors[$r->idTutor]['participations'] = array_remove_item($r->idStudent, $tutors[$r->idTutor]['participations']);
				$pdo->query("DELETE FROM Participation WHERE idTutor = $r->idTutor AND idStudent = $r->idStudent");
				$tutors[$r->idTutor]['participations'][] = $idStudent;
				$pdo->query("INSERT INTO Participation (idTutor, idStudent, idSession) VALUES ($r->idTutor, $idStudent, $idSession)");
				$tutors[$idTutor]['participations'][] = $r->idStudent;
				$pdo->query("INSERT INTO Participation (idTutor, idStudent, idSession) VALUES ($idTutor, $r->idStudent, $idSession)");
				$tutors[$idTutor]['slots']--;
				$switch = true;
			}
		}
		if (!$switch) {
			$studentsIds[] = $idStudent;
		}
	}
	return $studentsIds;
}


$tutorsIds = $pdo->query('SELECT id FROM Tutor')->fetchAll(PDO::FETCH_COLUMN, 0);
$studentsIds = $pdo->query('SELECT id FROM Student')->fetchAll(PDO::FETCH_COLUMN, 0);
$studentsCount = count($studentsIds);
$slots = intval(ceil($studentsCount / count($tutorsIds)));
$tutors = [];
$retry = 4;
while (count($studentsIds) != 0 && $retry != 0) { //FIXME: can fail to plan interviews
	$pdo->query('DELETE FROM Participation');
	foreach ($tutorsIds as $id) {
		$tutors[$id] = [ 'participations' => [], 'votes' => $pdo->query('SELECT idStudent FROM Vote WHERE idTutor = ' . $id)->fetchAll(PDO::FETCH_COLUMN, 0) ];
	}
	for ($idSession = 1; $idSession <= $session_count; $idSession++) {
		foreach ($tutors as &$tutor) $tutor['slots'] = $slots;
		$studentsIds = $pdo->query('SELECT id FROM Student')->fetchAll(PDO::FETCH_COLUMN, 0);
		for ($i = 0; $i < $studentsCount ; $i++) {
			$idStudent = affectStudent($studentsIds, $tutors, $idSession);
			if ($idStudent != 0) {
				$studentsIds = array_remove_item($idStudent, $studentsIds);
			}
		}
		if (count($studentsIds) != 0) {
			$studentsIds = fixAttributions($tutors, $studentsIds, $idSession);
		}
	}
	$retry--;
}
if ($DEBUG) { echo '<a href="index.php">Continue</a>'; die(); }
header('Location: index.php');
?>
